%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% Space Tug utility calculator

function [MAU SAU] = SpaceTugMAUcalc(attributes, prefs, weights)
% INPUTS
    % attributes = a designsXattributes array of the attribute values for the designs
    
    % prefs = a 1xN cell array of an Mx2 arrays (variable M,N) where the first column
    % corresponds to a given amount of the attribute (ie, amount of deltaV)
    % and the second column is the value of that amount.  Amounts inbetween
    % specified points will be linearly interpolated
        % N = number of attributes, M can be anything
        % SHOULD INCLUDE THE ZERO POINT
        % must have HIGHER values of the attribute be better: if this is
        % not the case (ie, response time), then use opposites
    
    % weights = an N element array of preference weightings. SHOULD SUM TO 1
    
% OUTPUTS
    % MAU = a column vector of MAU for the designs
    % SAU = a design by attribute SAU array

SAU = zeros(size(attributes,1),size(attributes,2));
MAU = zeros(size(attributes,1),1);
    
for d = 1:size(attributes,1)
    for a = 1:size(attributes,2)
        currAtt = attributes(d,a);
    
        if any(currAtt == prefs{a}(:,1))
            idx = prefs{a}(:,1)==currAtt;
            SAU(d,a) = prefs{a}(idx,2);
        else
            idx = find(prefs{a}(:,1)>currAtt,1);
            if isempty(idx)
                SAU(d,a) = 1; % this is the "no point is bigger --> U=1" case
            elseif idx == 1
                SAU(d,a) = NaN; % this is the "all points are bigger --> unacceptable" case
            else
                slope = (prefs{a}(idx,2)-prefs{a}(idx-1,2))/(prefs{a}(idx,1)-prefs{a}(idx-1,1));
                SAU(d,a) = prefs{a}(idx-1,2) + slope*(currAtt-prefs{a}(idx-1,1));
            end
        end
        
    end
    
    MAU(d,1) = sum(SAU(d,:).*weights); % done this way so weights can be a column or row
end


end